/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.util;

import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class GenericNonValidatingParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPAGNVPT";
    private static final String TRACE_MASKF = "XPAGNVPF";
    private static final String TRACE_MASKD = "XPAGNVPD";

    public GenericNonValidatingParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "GenericNonValidatingParser.ctor");
    }

    public static NodeList parseXML(InputSource is, String tagname) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "GenericNonValidatingParser.parseXML(InputSource," + tagname + " )");
        try {
            GenericNonValidatingParser parser = new GenericNonValidatingParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            if (parser != null) {
                Trace.trace(TRACE_MASKD, "acquired parser");
            } else {
                Trace.trace(TRACE_MASKD, "could not acquire parser");
            }
            parser.parse(is);
            Document doc = parser.getDocument();
            if (doc != null) {
                Trace.trace(TRACE_MASKD, "got the Document");
            } else {
                Trace.trace(TRACE_MASKD, "no Document");
            }
            NodeList root = doc.getElementsByTagName(tagname);
            Trace.trace(TRACE_MASKD, "nodelist length" + root.getLength() + " what we looked for=" + tagname);
            return root;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException! " + e);
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException! " + GenericNonValidatingParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    public static NodeList parseXML(File file, String tagname) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "GenericNonValidatingParser.parseXML(" + file + ")");
        try {
            InputSource xmlSource = new InputSource(new FileInputStream(file));
            return GenericNonValidatingParser.parseXML(xmlSource, tagname);
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException! " + e);
        }
    }

    public static NodeList parseXML(String xmlString, String tagname) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "GenericNonValidatingParser.parseXML(" + xmlString + ")");
        InputSource xmlSource = new InputSource(new StringReader(xmlString));
        return GenericNonValidatingParser.parseXML(xmlSource, tagname);
    }

    public static NodeList parseXML(StringBuffer xmlBuffer, String tagname) throws MalformedXMLException {
        return GenericNonValidatingParser.parseXML(xmlBuffer.toString(), tagname);
    }

    public static NodeList parseXMLFileNameForTag(String fileName, String tagname) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "GenericNonValidatingParser.parseXMLFileNameForTag(" + fileName + "," + tagname + ")");
        return GenericNonValidatingParser.parseXML(new File(fileName), tagname);
    }
}

